;
;***********************
;  DEMO STEPPING MOTOR *
;      EXPERIMENT 5    *
;***********************
;
        CPU  "8085.TBL"
        HOF  "INT8"
;
         ORG  2100H
STPXY:   EQU  0B5H
STPCTRL: EQU  0B7H
DISPY:   EQU  2076H
SCANK:   EQU  5
CLEAR:   EQU  3
SYSCAL:  EQU  2
BEEP:    EQU  0EH
KEYIN:   EQU  208AH
SYSFAG:  EQU  208CH
DELAY:   EQU  0FH
;
;
START:  MVI  A,10011001B
        OUT  STPCTRL
;
        LXI  H,TAB_DSP
        LXI  D,DISPY
        MVI  B,6
START0: MOV  A,M
        STAX D
        INX  H
        INX  D
        DCR  B
        JNZ  START0
;
        LDA  SYSFAG
        ORI  00010000B
        STA  SYSFAG
;
START1: MVI  A,99H
        STA  PHASEX
        STA  PHASEY
        LXI  H,MEMXY
        SHLD BUFXY
        LXI  H,0
        SHLD COUNTXY
;
MAIN:   LXI  H,0
        SHLD CONTX
        SHLD CONTY
;
MAIN2:  MVI  A,SCANK
        RST  SYSCAL
;
        LDA  KEYIN
        CPI  0FFH
        JNZ  MAIN21
        XRA  A
        OUT  STPXY
        JMP  MAIN2
;
MAIN21: CPI  0
        JZ   PRGXR
        CPI  1
        JZ   PRGXL
        CPI  2
        JZ   PRGYR
        CPI  3
        JZ   PRGYL
        CPI  11H
        JZ   PRG_RUN
        CPI  10H
        JNZ  MAIN2
;
        MVI  A,BEEP
        RST  SYSCAL
MAIN3:  MVI  A,SCANK
        RST  SYSCAL
        LDA  KEYIN
        CPI  10H
        JZ   MAIN3
        JMP  PRG_MEM
;
;***********************
;   PROGRAM MOVE X,Y   *
;***********************

PRGXR:  CALL PHASXL
        LHLD CONTX
        INX  H
        SHLD CONTX
        CALL ENGISE
        JMP  MAIN2
;
PRGXL:  CALL PHASXR
        LHLD CONTX
        DCX  H
        SHLD CONTX
        CALL ENGISE
        JMP  MAIN2
;
PRGYR:  CALL PHASYL
        LHLD CONTY
        INX  H
        SHLD CONTY
        CALL ENGISE1
        JMP  MAIN2
;
PRGYL:  CALL PHASYR
        LHLD CONTY
        DCX  H
        SHLD CONTY
        CALL ENGISE1
        JMP  MAIN2
;
;***********************
;  PROGRAM MEMORY X,Y  *
;***********************

PRG_MEM:  LHLD COUNTXY
        INX  H
        SHLD COUNTXY
        LHLD BUFXY
        LDA  CONTX
        MOV  M,A
        INX  H
        LDA  CONTX+1
        MOV  M,A
        INX  H
        LDA  CONTY
        MOV  M,A
        INX  H
        LDA  CONTY+1
        MOV  M,A
        INX  H
        SHLD BUFXY
        JMP  MAIN
;
;***********************
;    PROGRAM RUN X,Y   *
;***********************

PRG_RUN:
        LHLD COUNTXY
        MOV  A,H
        ORA  L
        JZ   MAIN
        LXI  H,MEMXY
        SHLD BUFXY
;
;/* step X left execute */

RUNX_RL:
        CALL RD_DAT
        JZ   RUNY_RL
        JM   RUN_XR
;
RUN_XL: CALL PHASXL
        CALL ENGISE
        DCX  D
        MOV  A,D
        ORA  E
        JNZ  RUN_XL
        JMP  RUNY_RL
;
;/* step X right execute */

RUN_XR: CALL NUM_MINUS
RUN_XR1:
        CALL PHASXR
        CALL ENGISE
        DCX  D
        MOV  A,D
        ORA  E
        JNZ  RUN_XR1
;
;/* step Y left execute */

RUNY_RL:
        CALL RD_DAT
        JZ   EN_1PRG
        JM   RUN_YR
;
RUN_YL: CALL PHASYL
        CALL ENGISE1
        DCX  D
        MOV  A,E
        ORA  A
        JNZ  RUN_YL
        JMP  EN_1PRG
;
;/* step Y right execute */

RUN_YR: CALL NUM_MINUS
RUN_YR1:
        CALL PHASYR
        CALL ENGISE1
        DCX  D
        MOV  A,D
        ORA  E
        JNZ  RUN_YR1
;
;/* end 1 program */

EN_1PRG:
        MVI  A,BEEP
        RST  SYSCAL
        MVI  B,50H
        MVI  A,DELAY
        RST  SYSCAL
;
        LHLD COUNTXY
        DCX  H
        SHLD COUNTXY
        MOV  A,H
        ORA  L
        JNZ  RUNX_RL
        JMP  START1
;
;***********************
;    READ BUFFER X,Y   *
;***********************

RD_DAT: LHLD BUFXY
        MOV  E,M
        INX  H
        MOV  D,M
        INX  H
        SHLD BUFXY
        MOV  A,D
        ORA  E
        RET
;
;***********************
; CHANGE MINUS TO PLUS *
;***********************

NUM_MINUS:
        MOV  A,D
        CMA
        MOV  D,A
        MOV  A,E
        CMA
        MOV  E,A
        LXI  H,1
        DAD  D
        XCHG
        RET
;
;***********************
;   CONTROL PHASE X -> *
;***********************

PHASXL: LDA  PHASEX
        RLC
        STA  PHASEX
        RET
;
;***********************
;   CONTROL PHASE X <- *
;***********************

PHASXR: LDA  PHASEX
        RRC
        STA  PHASEX
        RET
;
;***********************
;   CONTROL PHASE Y ^  *
;***********************

PHASYL: LDA  PHASEY
        RLC
        STA  PHASEY
        RET
;
;***********************
;   CONTROL PHASE Y _  *
;***********************

PHASYR: LDA  PHASEY
        RRC
        STA  PHASEY
        RET
;
;***********************
;     ENERGISE X       *
;***********************

ENGISE: ANI  0FH
        OUT  STPXY
        CALL SPEED
        RET
;
;***********************
;       ENERGISE Y     *
;***********************

ENGISE1:
        ANI  0F0H
        OUT  STPXY
        CALL SPEED
        RET
;
;***********************
;        DELAY SUB.    *
;***********************

SPEED:  LXI  H,4000H
SPD1:   DCX  H
        MOV  A,H
        ORA  L
        JNZ  SPD1
        RET
;
TAB_DSP: DFB  00H,73H,50H,5CH,3DH,00H


;*** RAM AREA ***

         ORG   3000H
MEMXY:   DFS   0F00H
BUFXY:   DFS   2
COUNTXY: DFS   2
CONTX:   DFS   2
CONTY:   DFS   2
PHASEX:  DFS   1
PHASEY:  DFS   1
PHASEZ:  DFS   1
         END

;
